#version 140
#extension GL_EXT_gpu_shader4 : enable
//Pretty patternMod01.fsh by TheGrego
//https://www.shadertoy.com/view/XlfyR2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize
#define U gl_FragCoord.xy

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define POINT_COUNT 5.0
#define PATTERN_SCALE 4.0

void main (void)
//void mainImage( out vec4 fragColor, in vec2 U )
{
	// set the uv
	vec2 uv = iResolution.xy;
    uv = (U + U - vec2(uv)) / uv.y;
    
    vec2 muv = uv;
   	muv *= PATTERN_SCALE;
	muv *= sin(iTime * 0.5 - length(muv) );
    
    float a = atan(muv.y, muv.x);
    
    float size = 0.2 + sin(a * 5.0);
    float val = fract(iTime * 0.25 - length(muv) 
                      + sin( a * POINT_COUNT) 
                      * size );
    val = smoothstep( 0.45, 0.65, val);
   	
    float fade = smoothstep( 0.0, 0.2, 1.0 - length(uv));

    gl_FragColor = vec4( vec3(val) * fade, 1.0);
	gl_FragColor.a = length(gl_FragColor.rgb);
	
}




